#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Res_Description=IP Finder
#AutoIt3Wrapper_Res_Fileversion=2.0
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;
; KissCloneHunter
; Based on CloneHunter 2.2 code
; Designed and created by Fuhrmanator@gmail.com, 2006-03-15
;
; Updated and developed for 1.12 by PortalDeamon000 2008-09-30
; (also developed later versions)



;;Autoit3 libraries
#include <Date.au3>
#include <GuiConstants.au3>
#include <GuiEdit.au3>
#include <ProgressConstants.au3>
#include <String.au3>
#include <WindowsConstants.au3>
#include <ListViewConstants.au3>
#include <TabConstants.au3>
#include <WinAPI.au3>

;;Custom functions
#include <NomadMemory.au3>
#include <MinimizedMsg.au3>

Opt("TrayAutoPause",0)

#Region startupvariables
Global Const $VersionInfo = 'KissCloneHunter 2.0'
Global Const $AdvClientFile = 'KCH2.0Client.exe'

Global $GameCount = 0
;; handle to controls in the lobby screen - from R1CH and EoN
Global $OFFSET_D2MULTI_SCREEN = 0x6FA09154
Global $OFFSET_D2MULTI_IPADDRESS_ASCII = 0x6FA2B1F8
Global $OFFSET_D2MULTI_LAST_CHAT_MSG = 0x6FBCFC40
Global $OFFSET_GAME_PING = 0x6FBB32BC
Global $OFFSET_GAMEINFO = 0x11B908
Global $OFFSET_GAMENAME = 0x1A
Global $OFFSET_GAMEPASSWORD = 0x23F

Global $MESSAGE_DIABLO_WALKS_THE_EARTH = "Diablo Walks the Earth"
Global $MESSAGE_STONES_OF_JORDAN_SOLD = " Stones of Jordan Sold to Merchants"

Global $LOBBY_MAIN_CREATE_X			= 600
Global $LOBBY_MAIN_CREATE_Y			= 463
Global $LOBBY_MAIN_JOIN_X			= 706
Global $LOBBY_MAIN_JOIN_Y			= 463
Global $LOBBY_CREATE_HELL_X			= 706
Global $LOBBY_CREATE_HELL_Y			= 375
Global $LOBBY_CREATE_NORM_X			= 439
Global $LOBBY_CREATE_NORM_Y			= 375
Global $LOBBY_CREATE_X				= 706
Global $LOBBY_CREATE_Y				= 375
Global $LOBBY_CREATE_CREATE_GAME_X	= 684
Global $LOBBY_CREATE_CREATE_GAME_Y	= 420

Global $changedip = 0

;advanced only variables
Global $windowtitlearray, $winlist1, $winlist2, $winlist3, $totallabel, $profile, $profilecombo, $ipinput, $durationinput, $diffh, $diffn, $prefixinput, $passinput

$DebugForceFind = 0  ;; used for testing only

$UserUniqueGameName = 0
$UserUniqueGamePass = ""
$GameNumber = 0
$GameName = 0
$GamePass = 0
$CurrentIP = 0
$IPList = 0
$HuntSoundFile = @ScriptDir & '\diablo_hunt.wav'
$FoundSoundFile = @ScriptDir & '\tada.wav'
$DroppedSoundFile = @ScriptDir & '\dropped.mp3'
$WindowName = "Diablo II"
$radio_1 = ""
$radio_2 = ""
$input_1 = ""
$input_2 = ""
$input_3 = ""
$input_4 = ""
$input_5 = ""
$input_6 = ""
$oldMessage = ""

;; GUI positioning
$GUIWindowWidth = 250
$GUIWindowHeight = 510
$GUIWindowX = 600
$GUIWindowY = 0

$MSG_TimeToNextGame = "Time left:"

Dim $HuntedIPs[4] ;; gets redimensioned later, but we need its scope here

$GameDurationSeconds = 180
$AdjustedGameLengthSeconds = 0

;; Note - some users (including the author) experienced, at times,
;; frequent "failed to join game" errors after a new game is created.
;; Increasing the value below might help, but my experience shows
;; that even at 10 seconds, the problem can still occur.
;; If the delay is too small (e.g., 1 second), "failed to join game"
;; errors occur almost every time. There is likely another reason
;; for this error when delay before new game is higher, possibly
;; packet-loss on the local ISP, using a character that was in a game
;; that recently crashed, etc.

$DelayBeforeNewGameSeconds = 5

;; generate a random letter (a-z) plus a 3-digit number (000-999) for game name prefix
$UserUniqueGameName = Chr(96 + Random(1, 26, 1)) & Random(0,9,1) & Random(0,9,1) & Random(0,9,1) & "-"
$PrivateMessageRecipient = ""
$AntiIdleDelayMS = 30 * 1000  ;; 30 secs
#EndRegion

; GUI - startup gui with update option
$startgui = GUICreate($VersionInfo, 330,160)
$button_1 = GuiCtrlCreateButton("Run Standard", 10, 10, 100, 50)
$button_2 = GUICtrlCreateButton("Help - How to Use", 10, 65, 100, 30)
$button_3 = GuiCtrlCreateButton("Cancel", 220, 10, 100, 50)
$button_4 = GUICtrlCreateButton("Check For Updates", 220, 65, 100, 30)
$button_5 = GUICtrlCreateButton("Rename Windows", 115, 25, 100, 70)
$advanced = GUICtrlCreateButton("Run Advanced (experienced users only)",10,100,310,50)
GUISetState(@SW_SHOW,$startgui)

While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $button_1
			GUIDelete($startgui)
            ExitLoop
		case $msg = $advanced
			GUIDelete($startgui)
            _advanced()
		Case $msg = $button_2
            ShellExecute("readme.txt")
		Case $msg = $button_3
            Exit
		Case $msg = $button_4
			_Update()
		Case $msg = $button_5
			_winrename()
		Case $msg = $GUI_EVENT_CLOSE
            Exit
	EndSelect
WEnd

#Region standardKCH
;=====================================================================
;=====================================================================
;=====================================================================
;----------Standard KCH Version Main and Functions -------------------
;=====================================================================
;=====================================================================
;=====================================================================


;; intro sound for cool (?) factor
SoundPlay($HuntSoundFile)

;; option param = 16 so window can be moved if needed, smaller font (10 pt?)
;GUIWindowOn ( $VersionInfo, $VersionInfo & ' by Fuhrmanator, based on code by Snarg', $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, 16, "", 10 )

; cell positioning of all new GUI components
AutoItSetOption("GUICoordMode", 2)
;~ AutoItSetOption("GUIOnEventMode", 1)

; GUI - make it resizable, and force it to top always
$maingui = GUICreate($VersionInfo, $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, $WS_THICKFRAME + $WS_MINIMIZEBOX + $WS_SYSMENU + $WS_CAPTION);;, $WS_EX_TOPMOST + $WS_EX_TOOLWINDOW)

GUISetOnEvent($GUI_EVENT_CLOSE, "CLOSEClicked")

$WinNameLabel = GUICtrlCreateLabel("Window: ", 3, 3, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

;Change IPs BUTTON
GUICtrlCreateButton("Change IPs:",-1,0,75)
GUICtrlSetOnEvent( -1, "ChangeIP")
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH )

$IPListLabel = GUICtrlCreateLabel("", 5, -1, $GUIWindowWidth - 85)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

;Change Delay BUTTON
GUICtrlCreateButton("Change Delay:",5 - $GUIWindowWidth,0,90)
GUICtrlSetOnEvent( -1, "ChangeDelay")
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH )

$GameDurationLabel = GUICtrlCreateLabel("", 5, -1, $GUIWindowWidth - 100)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

; Pause BUTTON
$PauseButton = GUICtrlCreateButton("Pause", 5 - $GUIWindowWidth, 0,$GUIWindowWidth - 10)
GUICtrlSetOnEvent( -1, "PauseButton")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$HuntPaused = 0
GUICtrlSetState( -1, $GUI_DISABLE)

; Hold Game/Abandon Game BUTTON
$HoldAbandonButton = GUICtrlCreateButton("Hold Game", -1, 0,$GUIWindowWidth - 10)
GUICtrlSetOnEvent( -1, "HoldAbandon")
$HoldGame = 0
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )

; Timer PROGRESS
$ProgressLabel = GUICtrlCreateLabel($MSG_TimeToNextGame, -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$Progress = GUICtrlCreateProgress(-1, 0, $GUIWindowWidth - 10, 20, $PBS_SMOOTH)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetData(-1, 0)

; KEEP MINIMIZED checkbox
$MinimizedCheckbox = GUICtrlCreateCheckbox( "Run D2 Minimized", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetState ( -1, $GUI_CHECKED)

; INTERRUPT HUNT ON SOJ sales activity checkbox
$InterruptOnSalesCheckbox = GUICtrlCreateCheckbox( "Hold game on SoJ sale or Walk msg", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetState( -1, $GUI_UNCHECKED + $GUI_DISABLE)

; Disable warning BEEP before activating a window
$DisableBeepCheckbox = GUICtrlCreateCheckbox( "Disable Warning Beep", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )

; Log of messages
$LogText = GUICtrlCreateEdit($VersionInfo & @CRLF & ' by PortalDeamon000' & @CRLF & ' original version by Fuhrmanator' & @CRLF, -1, 0, $GUIWindowWidth - 5, $GUIWindowHeight - 205)
GUICtrlSetResizing($LogText, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)

AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

;;==================================================
;; Main code starts here
;;==================================================

VerifyDisplaySettings()

;; intro sound for cool (?) factor
SoundPlay($HuntSoundFile)

AskForAllInfo()

; Display main GUI window
AutoItSetOption("GUIOnEventMode", 1)
GUISetState(@SW_SHOW,$maingui)

;; must have this priv to read d2's memory
_SetPrivilege ("SeDebugPrivilege", 1)

GUICtrlSetData($WinNameLabel, "Window: " & $WindowName)
GUICtrlSetData($IPListLabel, $IPList)
GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")

if Not WinExists($WindowName) Then
	GUIDelete($maingui)
	MsgBox(48, "ERROR", "Window: " & $WindowName & " appears not to be running. Exiting...")
	Exit
EndIf
Sleep(100)
;~ ActivateRestoreDiabloWindow()
Sleep(500)
if IsGameActive() Then
	$userResponse = MsgBox(6 + 32 + 262144, $VersionInfo & ": Notice", "KCH has noticed that you are currently in a game already. Do you want to anti-idle this game?" & @CRLF & "Press Continue to anti-idle, or Try Again to have the bot return to lobby and hunt")
    If $userResponse = 2 Then
    ;; user chose to cancel, exit...
        Exit
	ElseIf $userResponse = 11 Then
	;; user chose to camp this game
		If (GUICtrlRead($MinimizedCheckbox) = $GUI_CHECKED) Then WinSetState($WindowName,"",@SW_MINIMIZE)
		getgamenamepass()
	ElseIf $userResponse = 10 Then
	;; user chose to return to lobby and hunt
		ExitGame()
		AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
		Sleep($DelayBeforeNewGameSeconds * 1000)
		VerifyLobbyScreenUp()
		If (GUICtrlRead($MinimizedCheckbox) = $GUI_CHECKED) Then WinSetState($WindowName,"",@SW_MINIMIZE)
		_Main()
	EndIf

Else
	VerifyLobbyScreenUp()
	If (GUICtrlRead($MinimizedCheckbox) = $GUI_CHECKED) Then WinSetState($WindowName,"",@SW_MINIMIZE)
EndIf

_Main()
Exit

Func _Main()
	while (1)
    
		CreateGame()
		Sleep(500)
		_SendMinimized($WindowName, '{TAB}')  ;; turn on the info to display gamename/etc

		;; check to see if current game's IP is in list of hunted IPs
		$CurrentIP = Read_Diablo_Memory (GetD2ProcessID(), $OFFSET_D2MULTI_IPADDRESS_ASCII, 'char[16]')
		AppendLineToLogText("Joined game IP: " & $CurrentIP)
    
		If IsIPFound($CurrentIP) Then
			AckHuntedIPFound()
		EndIf

		;==============================
		; prepare to wait in the game
		;==============================
	
		;; calculate the game time in seconds
		$AdjustedGameLengthSeconds = $GameDurationSeconds - $DelayBeforeNewGameSeconds

		;; clear the last message seen on the D2 client
;~ 		$oldMessage = ""
    
		UnPause()
		GUICtrlSetState($PauseButton, $GUI_ENABLE)

		;; wait in the game, displaying the time remaining and the progress bar
		For $sleepSecond = $AdjustedGameLengthSeconds To 0 Step - 0.5
        
			;;check if ingame and currentip is hunted
			if $changedip = 1 Then
				$changedip = 0
				if IsGameActive() Then
					If IsIPFound($CurrentIP) Then
						AckHuntedIPFound()
					EndIf
				EndIf
			EndIf
			
			$percentComplete = Int(100 * ($AdjustedGameLengthSeconds - $sleepSecond) / $AdjustedGameLengthSeconds)
        
			GUICtrlSetData($ProgressLabel, $MSG_TimeToNextGame & Int($sleepSecond) & " sec.")
			GUICtrlSetData($Progress, $percentComplete)
        
			;; beep to signal that the timer's about to run out
			If $sleepSecond < 5 And $sleepSecond = Int($sleepSecond) Then
				MyBeep()
			EndIf
        
			Sleep(500)
        
			;; if the user pressed the pause button, the variable will be set
			While $HuntPaused = 1
				Sleep(500)
			WEnd
			if $HoldGame = 1 Then
				getgamenamepass()
			EndIf
        
			;; check for SOJ sales and/or Diablo Walks here,
			;; in case it happens while we're waiting for next game
			;; (that would be bad to ignore it!)
			If GetLastChatMessage() <> $oldMessage Then
				$oldMessage = GetLastChatMessage()
				If StringCompare($oldMessage, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
					AppendLineToLogText($CurrentIP & "@WALK")
					;; only check for messages if user has requested
					If (GUICtrlRead($InterruptOnSalesCheckbox) = $GUI_CHECKED) Then InterruptHunt()
				ElseIf StringCompare(StringRight($oldMessage, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
					AppendLineToLogText($CurrentIP & "@" & StringReplace($oldMessage,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & " sojs")
					;; only check for messages if user has requested
					If (GUICtrlRead($InterruptOnSalesCheckbox) = $GUI_CHECKED) Then InterruptHunt()
				EndIf
			EndIf
		Next
    
		GUICtrlSetState($PauseButton, $GUI_DISABLE)
		GUICtrlSetData($Progress, 0)
    
		ExitGame()

		AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
		Sleep($DelayBeforeNewGameSeconds * 1000)
    
	WEnd
EndFunc

; =========== Subroutines ===============

Func VerifyDisplaySettings()
    
    If @DesktopWidth < 800 Or @DesktopHeight < 600 Then
        MsgBox(16 + 0, "Display settings incorrect", "Sorry. For this program to function properly, " & @CRLF & "your screen's resolution must be at least 800 x 600")
        Exit
    EndIf
    
EndFunc   ;==>VerifyDisplaySettings 

; ===========================================
Func AskForAllInfo()
	; GUI - ask for info gui
	$infogui = GUICreate($VersionInfo,300,460)
	$label_0 = GUICtrlCreateLabel("Difficulty:",10,10,60,20)
	GUICtrlSetFont($label_0,10)
	$radio_1 = GUICtrlCreateRadio("Normal",0,-1,60,20)
	$radio_2 = GUICtrlCreateRadio("Hell",0,-1,50,20)
	GUICtrlSetState($radio_2,$GUI_CHECKED)
	$label_1 = GUICtrlCreateLabel("Window Title:",-170,10,85,20)
	GUICtrlSetFont($label_1,10)
	$input_1 = GUICtrlCreateInput($WindowName,0,-1,195,20)
	$label_2 = GUICtrlCreateLabel("Enter the name of your Diablo II window here. If using multiple windows, they must all have unique names.",-280,3,280,30)
	$label_3 = GUICtrlCreateLabel("IP List:",-1,5,50,20)
	GUICtrlSetFont($label_3,10)
	$input_2 = GUICtrlCreateInput("66, 141",0,-1,230,20)
	$label_4 = GUICtrlCreateLabel("Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address.",-280,3,280,40)
	$label_5 = GUICtrlCreateLabel("Game Duration:",-1,5,95,20)
	GUICtrlSetFont($label_5,10)
	$input_3 = GUICtrlCreateInput($GameDurationSeconds,0,-1,185,20)
	$label_6 = GUICtrlCreateLabel("Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.",-280,3,280,40)
	$label_7 = GUICtrlCreateLabel("Game Name Prefix:",-1,5,115,20)
	GUICtrlSetFont($label_7,10)
	$input_4 = GUICtrlCreateInput($UserUniqueGameName,0,-1,165,20)
	$label_8 = GUICtrlCreateLabel("Please enter a prefix for the games to use (should be unique)",-280,3,280,30)
	$label_9 = GUICtrlCreateLabel("Optional Game Password:",-1,5,155,20)
	GUICtrlSetFont($label_9,10)
	$input_5 = GUICtrlCreateInput($UserUniqueGamePass,0,-1,125,20)
	$label_10 = GUICtrlCreateLabel("Entering a password here will set a custom password.  Leave blank for default game number as password.",-280,3,280,30)
	$label_11 = GUICtrlCreateLabel("Optional Notification:",-1,5,125,20)
	GUICtrlSetFont($label_11,10)
	$input_6 = GUICtrlCreateInput($PrivateMessageRecipient,0,-1,155,20)
	$label_12 = GUICtrlCreateLabel("Please enter the Battle.net account ID that should receive a private message if an IP has been found (do not include the *). Leave blank for no message.",-280,3,280,40)
	$nxt_button = GUICtrlCreateButton("Next -->",-280,10)
	GUISetState(@SW_SHOW,$infogui)

	While 1
		$msg = GUIGetMsg()
		Select
			Case $msg = $nxt_button
				$checkval = checkinfo()
				if $checkval = 0 Then
					GUIDelete($infogui)
					ExitLoop
				ElseIf $checkval = 1 Then
					GUICtrlSetState($input_1,$GUI_FOCUS)
				ElseIf $checkval = 2 Then
					GUICtrlSetState($input_2,$GUI_FOCUS)
				ElseIf $checkval = 3 Then
					GUICtrlSetState($input_3,$GUI_FOCUS)
				ElseIf $checkval = 4 Then
					GUICtrlSetState($input_4,$GUI_FOCUS)
				ElseIf $checkval = 5 Then
					GUICtrlSetState($input_5,$GUI_FOCUS)
				ElseIf $checkval = 6 Then
					GUICtrlSetState($input_6,$GUI_FOCUS)
				EndIf
			Case $msg = $GUI_EVENT_CLOSE
				Exit
		EndSelect
	WEnd

    AskToPrepareClient()
    
EndFunc

; ===========================================

Func checkinfo()
	if GUICtrlRead($input_1) = "" Then
		MsgBox(48,$VersionInfo,"Window Title must have a unique value!")
		Return 1
	EndIf
	$InputIPList = StringStripWS(GUICtrlRead($input_2), 8)  ;; strip all spaces
	$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
	if Not $SplitIPs[0] >= 1 Then
		MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
		Return 2
	EndIf
	if Not (GUICtrlRead($input_3) >= 10 And StringIsInt(GUICtrlRead($input_3))) Then
		MsgBox(48,$VersionInfo,"Game Duration must be an integer and greater than 10 seconds!")
		Return 3
	EndIf

	if GUICtrlRead($input_4) = "" Or StringLen(GUICtrlRead($input_4)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Prefix must exist and cannot exceed 10 characters!")
		Return 4
	EndIf

	Local $val = GUICtrlRead($input_4)
	for $i=1 to StringLen($val)
		Local $val2 = StringMid($val,$i,1)
		if Not (StringIsAlNum($val2) or ($val2 = "-") or ($val2 = "_") or ($val2 = "'") or (($val2 = " ") And ($i > 1))) Then
			MsgBox(48,$VersionInfo,"Game Prefix cannot contain those invalid characters")
			Return 4
		EndIf
	Next
	
	if StringLen(GUICtrlRead($input_5)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Password cannot exceed 10 characters!")
		Return 5
	EndIf
	
	Local $val = GUICtrlRead($input_5)
	for $i=1 to StringLen($val)
		Local $val2 = StringMid($val,$i,1)
		if Not (StringIsAlNum($val2) or ($val2 = "-") or ($val2 = "_") or ($val2 = "'") or (($val2 = " ") And ($i > 1))) Then
			MsgBox(48,$VersionInfo,"Game Password cannot contain those invalid characters")
			Return 5
		EndIf
	Next
	
	;; first element of array after Split is number of returned elements
    ReDim $HuntedIPs [$SplitIPs[0]]
    $IPList = ""
	For $r = 1 To UBound($SplitIPs) - 1
		if Not StringIsInt($SplitIPs[$r]) Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		EndIf
		$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
        If $IPList = "" Then
            $IPList = $SplitIPs[$r]  ;; init to first split IP
        Else
            $IPList = $IPList & ", " & $SplitIPs[$r]
        EndIf
    Next
	$WindowName = GUICtrlRead($input_1)
	$GameDurationSeconds = GUICtrlRead($input_3)
	$UserUniqueGameName = GUICtrlRead($input_4)
	$UserUniqueGamePass = GUICtrlRead($input_5)
	$PrivateMessageRecipient = GUICtrlRead($input_6)
	if GUICtrlRead($radio_1) = $GUI_CHECKED Then
		$LOBBY_CREATE_X = $LOBBY_CREATE_NORM_X
		$LOBBY_CREATE_Y = $LOBBY_CREATE_NORM_Y
	EndIf
	if GUICtrlRead($radio_2) = $GUI_CHECKED Then
		$LOBBY_CREATE_X = $LOBBY_CREATE_HELL_X
		$LOBBY_CREATE_Y = $LOBBY_CREATE_HELL_Y
	EndIf
	Return 0
EndFunc

; ===========================================

Func AskToPrepareClient()
    
    $startResponse = MsgBox(1, $VersionInfo & ": Prepare D2 Client", "I will begin searching for the following IPs: " & $IPList & @CRLF & @CRLF & "Note: To stop me at any time, click my AutoIt icon in the system tray for a menu of options." & @CRLF & @CRLF & "Before continuing, make sure you have done the following:" & @CRLF & "1. Start Diablo in a separate window (-w option) and make sure the resolution is set to 800x600." & @CRLF & "2. Log in to your realm." & @CRLF & "3. Open a character that can create Hell-level games (make sure the Create button is on the screen).")
    
    If $startResponse = 2 Then  ;; cancel button
        Exit
    EndIf
    
EndFunc   ;==>AskToPrepareClient 

; ===========================================

Func getgamenamepass()
	$GameinfoStart = _ProcessGetLoadedModules(GetD2ProcessID())
;~ 	AppendLineToLogText("GameinfoStart: " & $GameinfoStart + $OFFSET_GAMEINFO)
	$Gameinfo = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoStart + $OFFSET_GAMEINFO, 'dword')
;~ 	AppendLineToLogText("Gameinfo: " & $Gameinfo)
	$GameinfoName = $Gameinfo + $OFFSET_GAMENAME
	$GameinfoPass = $Gameinfo + $OFFSET_GAMEPASSWORD
	$GameName = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoName, 'char[24]')
;~ 	AppendLineToLogText("GameName: " & $GameName)
	$GamePass = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoPass, 'char[24]')
;~ 	AppendLineToLogText("GamePass: " & $GamePass)
	HoldManualGame()
EndFunc

; ===========================================

Func ActivateRestoreDiabloWindow()
    
    WinActivate($WindowName)
    WinWaitActive($WindowName,"",3)
    WinSetState($WindowName, "", @SW_RESTORE)
    Sleep ( 500 )
    
EndFunc   ;==>ActivateRestoreDiabloWindow 

; ===========================================

Func ChangeIP()
	Local $val = 1
	$IPList_old = $IPList
	While $val = 1
		$val = 0
		Do
			$InputIPList = InputBox($VersionInfo & ": IP List", "Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address.", $IPList, " M",Default,Default,Default,Default,30)
        
			If @error <> 0 Then
				$InputIPList = StringStripWS($IPList_old, 8)  ;; strip all spaces
				$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
				
				ReDim $HuntedIPs [$SplitIPs[0]]
				$IPList = ""
    
				For $r = 1 To UBound($SplitIPs) - 1
					$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
					If $IPList = "" Then
						$IPList = $SplitIPs[$r]  ;; init to first split IP
					Else
						$IPList = $IPList & ", " & $SplitIPs[$r]
					EndIf
        
				Next
				Return
			EndIf
        
			$InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
			$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		Until $SplitIPs[0] >= 1
    
		;; first element of array after Split is number of returned elements
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""
    
		For $r = 1 To UBound($SplitIPs) - 1
			if Not StringIsInt($SplitIPs[$r]) Then
				MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
				$val = 1
			EndIf
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf
        
		Next
	WEnd
	GUICtrlSetData($IPListLabel, $IPList)
	$changedip = 1
EndFunc

; ===========================================

Func ChangeDelay()
	Do
        $value = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", $GameDurationSeconds, " M",Default,Default,Default,Default,30)
		if @error = 1 Then
			Return
		EndIf
    Until (($value >= 10) AND (StringIsInt($value)))
	$GameDurationSeconds = $value
	GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")
EndFunc

; ===========================================

Func PauseButton()
    
    If $HuntPaused = 0 Then
        Pause()
    Else
        UnPause()
    EndIf
    
EndFunc   ;==>PauseButton

; ===========================================

Func Pause()
    
    $HuntPaused = 1
    GUICtrlSetData($PauseButton, "Resume")
    $PausedText = GUICtrlRead($ProgressLabel) & " (paused)"
    GUICtrlSetData($ProgressLabel, $PausedText)
    GUICtrlSetBkColor($Progress, 0xff0000)
    
EndFunc   ;==>Pause

; ===========================================

Func UnPause()
    
    $HuntPaused = 0
    GUICtrlSetData($PauseButton, "Pause")
    $PausedText = ""
    GUICtrlSetBkColor($Progress, 0xffffff)
    ;; no need to update the label - it will get updated once game resumes
    
EndFunc   ;==>UnPause

; ===========================================

Func HoldAbandon()
	If $HoldGame = 0 Then
		Hold()
	Else
		Abandon()
	EndIf
    
EndFunc

; ===========================================

Func Hold()
    UnPause()
    $HoldGame = 1
    GUICtrlSetData($HoldAbandonButton, "Abandon Game")
;~ 	getgamenamepass()
    
EndFunc

; ===========================================

Func Abandon()
    UnPause()
	GUICtrlSetState($HoldAbandonButton,$GUI_DISABLE)
    $HoldGame = 0
	AppendLineToLogText("Abandoning the game")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
;~ 	ExitGame()
;~ 	AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
;~ 	Sleep($DelayBeforeNewGameSeconds * 1000)
;~ 	VerifyLobbyScreenUp()
EndFunc

; ===========================================

Func CloseClicked()
    
    Exit
    
EndFunc   ;==>CloseClicked

; ========================================

Func CreateGame()
	VerifyLobbyScreenUp()    
    Do
        $GameCount = $GameCount + 1
        AppendLineToLogText( "Current try: " & $GameCount)
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        
		;; click "Join" button (to make sure "Create" will be active; it can be grayed out after create fails)
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
		;; click "Create" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_CREATE_X, $LOBBY_MAIN_CREATE_Y)
		Sleep(400)
        ;; click Hell level button
        _MouseClickMinimized($WindowName, "left", $LOBBY_CREATE_X, $LOBBY_CREATE_Y)
		Sleep(400)
        
        ;; make game name and password
        $GameNumber = $GameNumber + 1
        $GameName = $UserUniqueGameName & $GameNumber
		if $UserUniqueGamePass = "" Then
			$GamePass = $GameNumber
		Else
			$GamePass = $UserUniqueGamePass
		EndIf
        AppendLineToLogText( "Trying to create " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        ;; FOR DEBUGGING -> _SendMinimized($WindowName, $GamePass)
        
    Until IsGameCreated() = 1
    
    Return
    
EndFunc   ;==>CreateGame 

; ========================================

;; logic is a bit strange here...

Func IsGameCreated()
    
    ; init a timer, so we can see how long this takes (for recovery)
    $TimerStart = TimerInit()
    
    ;; WaitForChangeInManaBall (1000, 7)  ;; milliseconds between checks, number of retries
    
    $RetryCount = 0
    Do
        If IsGameActive() Then
            Return 1
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
    
    
    ; Assume now that Game creation has failed and try to recover
    ; we only deal with "failed to join game" errors, so we assume that happened.
    ; All we can do is wait the gameduration or 40 seconds (so the screen goes away), because a game was created that we couldn't join
    if $GameDurationSeconds < 40 Then
		$InitSecondsRemaining = (40 - Int(TimerDiff($TimerStart) / 1000))
	Else
		$InitSecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
	EndIf
    AppendLineToLogText("Problem creating and joining game... Waiting " & $InitSecondsRemaining & " seconds, because game was likely created and I was unable to join it.")
	GUICtrlSetState($PauseButton, $GUI_ENABLE)
    For $sleepSecond = $InitSecondsRemaining To 0 Step - 0.5
        $percentComplete = Int(100 * ($InitSecondsRemaining - $sleepSecond) / $InitSecondsRemaining)
        
        
		;;check if ingame and currentip is hunted
		if $changedip = 1 Then
			$changedip = 0
			if IsGameActive() Then
				If IsIPFound($CurrentIP) Then
					AckHuntedIPFound()
				EndIf
			EndIf
		EndIf
		
		While $HuntPaused = 1
			Sleep(500)
		WEnd
		GUICtrlSetData($ProgressLabel, "Time before next game:" & Int($sleepSecond) & " sec.")
        GUICtrlSetData($Progress, $percentComplete)
		
		if $HoldGame = 1 Then
			getgamenamepass()
		EndIf
		
        ;; beep to signal that the timer's about to run out
        If ($sleepSecond <= 5) And ($sleepSecond = Int($sleepSecond)) Then
            MyBeep()
        EndIf
        
        Sleep(500)
        
    Next
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    VerifyLobbyScreenUp()
    
    Return 0
    
EndFunc   ;==>IsGameCreated 

; ========================================

Func IsLobbyScreenUp()
    
    If GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED Then ActivateRestoreDiabloWindow()
    
    $ProcessID = GetD2ProcessID()
    
    Local $DllInformation = _MemoryOpen ($ProcessID)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to open memory.")
        Exit
    EndIf
    
    $Value = _MemoryRead ($OFFSET_D2MULTI_SCREEN, $DllInformation, 'dword')
    
    ;; MsgBox(4096, "Value", $Value)
    
    ;##################################
    ;Close the process.
    ;##################################
    _MemoryClose ($DllInformation)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to close memory.")
        Exit
    EndIf
    
    If $Value <> 0 Then
        Return 1
    Else
        Return 0
    EndIf
    
EndFunc   ;==>IsLobbyScreenUp 

; ========================================

Func VerifyLobbyScreenUp()
    
    If Not IsLobbyScreenUp() Then
        Do
            $userResponse = MsgBox(5 + 32 + 262144, $VersionInfo & ": Problem", "Either the Lobby Screen is not active in the Diablo II window, or the Create button is grayed out and I cannot create a game." & @CRLF & "Please make sure you've opened a character in Diablo and are waiting in the lobby screen, with the Create button present and enabled.")
            If $userResponse = 2 Then
                ;; user chose to cancel, exit...
                Exit
            EndIf
        Until IsLobbyScreenUp()
    Else
		GUICtrlSetState($HoldAbandonButton,$GUI_ENABLE)
        ;; everything is good, continue on
    EndIf
    
EndFunc   ;==>VerifyLobbyScreenUp 

; ========================================

Func GetD2ProcessID()
    $ProcID = WinGetProcess($WindowName, "")
    If $ProcID = -1 Then
        MsgBox(4096, "ERROR", "Diablo Game appears not to be running. Exiting...")
        Exit
    EndIf
    Return $ProcID
EndFunc   ;==>GetD2ProcessID

; ========================================

Func IsGameActive()
    
    ;; if game is active, then the game ping will be > 0
    
    $ping = ReadGamePing()
    If $ping > 0 Then
        Return 1
    Else
        Return 0
    EndIf
    
EndFunc   ;==>IsGameActive 

; ========================================

Func ReadGamePing()

    Local $Value

    Local $ProcessID = GetD2ProcessID()
	$value = Read_Diablo_Memory($ProcessID, $OFFSET_Game_Ping, 'dword')

	Return $Value
    
EndFunc   ;==>ReadGamePing 

; ========================================

Func IsIPFound($IP)
    ;; find last "." in IP address
    $lastDot = StringInStr($IP, ".", 0, 3)
    ;; find last part of IP address
    $lastPart = StringMid($IP, $lastDot + 1)
    
    ;; search for last part of IP in the HuntedIP array
    If $DebugForceFind Then
        $HuntedIPIsFound = 1
    Else
        $HuntedIPIsFound = 0
    EndIf
    
    For $r = 0 To UBound($HuntedIPs) - 1
        ;; MsgBox(4096, 'Comparing', "Comparing '" & $HuntedIPs[$r] & "' to '" & $lastPart & "'")
        If $HuntedIPs[$r] = $lastPart Then $HuntedIPIsFound = 1
    Next
    Return $HuntedIPIsFound
EndFunc   ;==>IsIPFound

; ========================================

Func ExitGame()
    $HoldGame = 0
	GUICtrlSetData($HoldAbandonButton, "Hold Game")
    AppendLineToLogText( "Trying to exit game...")
    ; ControlSetText ( $VersionInfo, "", "Static1", "Hunting IPs: " & $IPList & @CRLF & "Current try: " & $GameCount &@CRLF & "Trying to exit game...")
    
    If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then
        ActivateRestoreDiabloWindow()
    EndIf
    
    ;; only try to exit if a game's not active
    
    If IsGameActive() Then
;~         _SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
;~         Sleep(100)
        
        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
		_SendMinimized($WindowName, '{UP}')
		Sleep(100)
		_SendMinimized($WindowName, '{ENTER}')
        
        ;; wait for screen to change
        $retries = 0
        While (Not IsLobbyScreenUp() And $retries < 20)
            Sleep(500)
            $retries = $retries + 1
        WEnd
        
    Else
        AppendLineToLogText( "Game is already inactive; attempting to continue without exiting.")
    EndIf
	If IsGameActive() Then
		AppendLineToLogText( "Failed to exit game. trying alternate method")
		_SendMinimized($WindowName, "{SPACE}{SPACE}")
        Sleep(100)
        
        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
        _MouseClickMinimized($WindowName, "left", 439, 259)  ;; coordinates of "Save and Exit Game"
		Sleep(500)
		_MouseClickMinimized($WindowName, "left", 439, 259)  ;; coordinates of "Save and Exit Game"
        
        ;; wait for screen to change
        $retries = 0
        While (Not IsLobbyScreenUp() And $retries < 20)
            Sleep(500)
            $retries = $retries + 1
        WEnd
	EndIf

    VerifyLobbyScreenUp()
    Return
    
EndFunc   ;==>ExitGame 

; ========================================

Func AckHuntedIPFound()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")
	
	_loginfo("Found: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    AppendLineToLogText("Hunted IP " & $CurrentIP & " has been found at")
	AppendLineToLogText("Game: " & $GameName & "//" & $GamePass)

    GUICtrlSetData($ProgressLabel, "Found IP " & $CurrentIP & "!")
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)

    ;; Give the user a chance to acknowledge the game has been found, NOT repeating the sound
	SoundPlay($FoundSoundFile)
	TrayTip("Success!!!", "Hunted IP " & $CurrentIP & " has been found!!!" & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf
		
		;; check for SOJ sales and/or Diablo Walks here and display them
		If GetLastChatMessage() <> $oldMessage Then
			$oldMessage = GetLastChatMessage()
			If StringCompare($oldMessage, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
				AppendLineToLogText($CurrentIP & "@WALK")
			ElseIf StringCompare(StringRight($oldMessage, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
				AppendLineToLogText($CurrentIP & "@" & StringReplace($oldMessage,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & " sojs")
			EndIf
		EndIf
		
		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)
	
	;; Give the user a chance to acknowledge the game has been dropped
	SoundPlay($DroppedSoundFile)
	
    RejoinLostGameIP()
    
    Return
    
EndFunc   ;==>AckHuntedIPFound 

; ========================================

Func RejoinLostGameIP()
	
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        
		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
        
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
        AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        
        $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            AckHuntedIPFound()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
	
	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	$HoldGame = 0
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_Main()
	
EndFunc

; ========================================

Func InterruptHunt()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")
	_loginfo("Sells: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    AppendLineToLogText("Interrupting hunt because of detected activity on current server.")
    
    ;; adjust the progress bar and Pause button
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($ProgressLabel, "Interrupted - SoJ sales " & $CurrentIP)
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)
    GUICtrlSetData($Progress, 0)
    
    ;; Give the user a chance to acknowledge the game is being held, NOT repeating the sound
    SoundPlay($FoundSoundFile)
	TrayTip("Possible success!!!", "Chat messages indicate activity on " & $CurrentIP & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf
		
		;; check for SOJ sales and/or Diablo Walks here and display them
		If GetLastChatMessage() <> $oldMessage Then
			$oldMessage = GetLastChatMessage()
			If StringCompare($oldMessage, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
				AppendLineToLogText($CurrentIP & "@WALK")
			ElseIf StringCompare(StringRight($oldMessage, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
				AppendLineToLogText($CurrentIP & "@" & StringReplace($oldMessage,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & " sojs")
			EndIf
		EndIf
		
		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)
		
	;; Give the user a chance to acknowledge the game has been dropped
	SoundPlay($DroppedSoundFile)
	
    RejoinLostGameInt()
    
    Return
    
EndFunc   ;==>InterruptHunt 

; ============================================

Func RejoinLostGameInt()
	
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        
		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
        
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
        AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        
        $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            InterruptHunt()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
	
	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	$HoldGame = 0
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()
	
EndFunc

; ========================================

Func HoldManualGame()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")
    AppendLineToLogText("Holding game " & $GameName & "//" & $GamePass)
	$CurrentIP = Read_Diablo_Memory (GetD2ProcessID(), $OFFSET_D2MULTI_IPADDRESS_ASCII, 'char[16]')
	AppendLineToLogText("Held game ip is: " & $CurrentIP)
	_loginfo("Holding game: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
    
    ;; adjust the progress bar and Pause button
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($ProgressLabel, "Holding Ip " & $CurrentIP)
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)
    GUICtrlSetData($Progress, 0)
    
    ;; Give the user a chance to acknowledge the game is being held, no sound
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf
		
		;; check for SOJ sales and/or Diablo Walks here and display them
		If GetLastChatMessage() <> $oldMessage Then
			$oldMessage = GetLastChatMessage()
			If StringCompare($oldMessage, $MESSAGE_DIABLO_WALKS_THE_EARTH , 1) = 0 Then
				AppendLineToLogText($CurrentIP & "@WALK")
			ElseIf StringCompare(StringRight($oldMessage, StringLen($MESSAGE_STONES_OF_JORDAN_SOLD)), $MESSAGE_STONES_OF_JORDAN_SOLD,1) = 0 Then
				AppendLineToLogText($CurrentIP & "@" & StringReplace($oldMessage,$MESSAGE_STONES_OF_JORDAN_SOLD,"",1,1) & " sojs")
			EndIf
		EndIf
		
		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
			
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)
    	
	;; Give the user a chance to acknowledge the game has been dropped
	SoundPlay($DroppedSoundFile)
	
    RejoinLostGameHold()
    
    Return
    
EndFunc   ;==>InterruptHunt 

; ============================================

Func RejoinLostGameHold()
	
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        
		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
        
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
        AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        
        $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            HoldManualGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
	
	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	$HoldGame = 0
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()
	
EndFunc

; ========================================

Func AntiIdle()

    If IsGameActive() Then
		;; anti-idle with random "vocal" message ("time to die!", etc.)
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
    Else
			
		;; Give the user a chance to acknowledge the game has been dropped
		SoundPlay($DroppedSoundFile)
		_loginfo("Game Dropped!: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
        AppendLineToLogText("Sorry. The game on the hunted IP " & $CurrentIP & " appears to have dropped")
		GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
;~         $userResponse = MsgBox(32, $VersionInfo & ": Problem", "Game " & $GameName & "//" & $GamePass & " appears to be lost (disconnected?). Check your Diablo II window.")
;~         Exit
    EndIf
    
EndFunc   ;==>AntiIdle 

; ============================================

Func SendSuccessMessage()
    
    _SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
    Sleep(250)
    
    ;; randomizing the message a bit with variable number of "!"
    
    If $PrivateMessageRecipient <> "" Then
        ;; note : if you don't bring the d2 window to front,
        ;; the success message (which is supposed to go to the
        ;; minimized window) doesn't work -
        ;; it stops after the first {enter}
		;; only does it if the game is set to not minimized
		If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then
			ActivateRestoreDiabloWindow()
			_SendMinimized($WindowName, "{ENTER}")
			Sleep(250)
			_SendMinimized($WindowName, "/m *" & $PrivateMessageRecipient & " Come to " & $GameName & "//" & $GamePass & " for a game on " & $CurrentIP & _StringRepeat("{!}", Random(1, 9, 1)))
			_SendMinimized($WindowName, "{ENTER}")
		EndIf

    EndIf
    
EndFunc   ;==>SendSuccessMessage 

; ============================================

Func GetLastChatMessage() ;Note, this function seems to return null on most systems. Disabled for now

    $Handle = _MemoryOpen (GetD2ProcessID())
    
    $pointer1 = _MemoryRead ($OFFSET_D2MULTI_LAST_CHAT_MSG, $Handle, 'dword')
    $pointer2 = _MemoryRead ($pointer1, $Handle, 'dword')
    $Temp = _MemoryReadWideString ($pointer2, $Handle, 'ushort[256]')
    
    _MemoryClose ($Handle)

;~     Return $Temp
	Return "" ;Return null (function broken)
EndFunc   ;==>GetLastChatMessage


; ============================================

Func AppendLineToLogText($TextToAppend)
	if StringLen(GUICtrlRead($LogText)) >= 29800 Then ;check if edit box is close to 30,000 character limit and clear it if so
		GUICtrlSetData($LogText,_NowTime() & " " & "Character limit reached. Text Cleared")
	EndIf
	_GUICtrlEdit_AppendText($LogText,_NowTime() & " " & $TextToAppend & @CRLF)
EndFunc   ;==>AppendLineToLogText

; ============================================

Func MyBeep()
    
    ;Found this on the AutoIt forums...
    
    ;Define             Value   Sound Alias
    ;Default beep       -1
    ;MB_OK              0x00    SystemDefault
    ;MB_ICONHAND        0x10    SystemHand
    ;MB_ICONQUESTION    0x20    SystemQuestion
    ;MB_ICONEXCLAMATION 0x30    SystemExclamation
    ;MB_ICONASTERISK    0x40    SystemAsterisk
    
    ;call BOOL MessageBeep(UINT uType);
	
	If (GUICtrlRead($DisableBeepCheckbox) = $GUI_UNCHECKED) Then
		DllCall("user32.dll", "int", "MessageBeep", "int", -1)
	EndIf
    
EndFunc   ;==>MyBeep 

;===============================================================================
;
; Function Name:  _SendMinimized()
;===============================================================================
Func _SendMinimized($Window, $keys)
    ;; note : testing with D2 shows that sending {ENTER} to open the chat screen
    ;;   requires that the D2 window be shown. Otherwise, all other keystrokes
    ;;   seem to be ingored, and the client stays in the chat mode.
	_SendMinimizedMessage(WinGetHandle($Window),$keys)
    
EndFunc   ;==>_SendMinimized

;========================================================

Func _ProcessGetLoadedModules($iPID)
    Local Const $PROCESS_QUERY_INFORMATION=0x0400
    Local Const $PROCESS_VM_READ=0x0010
    Local $aCall, $hPsapi=DllOpen("Psapi.dll")
    Local $hProcess, $tModulesStruct
    $tModulesStruct=DllStructCreate("hwnd [200]")
    Local $SIZEOFHWND = DllStructGetSize($tModulesStruct)/200
    $hProcess=_WinAPI_OpenProcess(BitOR($PROCESS_QUERY_INFORMATION,$PROCESS_VM_READ),False,$iPID)
    If Not $hProcess Then Return SetError(1,0,-1)
    $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",DllStructGetSize($tModulesStruct),"dword*","")
    If $aCall[4]>DllStructGetSize($tModulesStruct) Then
        $tModulesStruct=DllStructCreate("hwnd ["&$aCall[4]/$SIZEOFHWND&"]")
        $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",$aCall[4],"dword*","")
    EndIf
    Local $aReturn[$aCall[4]/$SIZEOFHWND]
	Local $returnval = 0
    For $i=0 To Ubound($aReturn)-1
        $aCall=DllCall($hPsapi,"dword","GetModuleFileNameExW","ptr",$hProcess,"int",DllStructGetData($tModulesStruct,1,$i+1),"wstr","","dword",65536)
		if (StringRight($aCall[3]	,13) = "\d2client.dll") Then
;~ 			MsgBox(0,$i,$aCall[3] & @CRLF & DllStructGetData($tModulesStruct,1,$i+1))
			$returnval = DllStructGetData($tModulesStruct,1,$i+1)
		EndIf	
        $aReturn[$i]=$aCall[3]
    Next
    _WinAPI_CloseHandle($hProcess)
    DllClose($hPsapi)
    Return $returnval
EndFunc

;;writes entry to a log file
Func _loginfo($message)
	if Not ($message == "") Then
		FileWriteLine("KCHlog.txt", _NowTime() & " " & $WindowName & ": " & $message)
	EndIf
EndFunc

;; renames dupicate D2 windows
Func _winrename()
	AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
	$winarray1 = WinList("classname=Diablo II")
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match
	for $i = 1 to $winarray1[0][0]
		$winarray3 = WinList($winarray1[$i][0])
		if $winarray3[0][0] > 1 Then
			$j = 1
			while $j < 100
				$winarray2 = WinList($winarray1[$i][0] & "-" & $j)
				if $winarray2[0][0] = 0 Then
					WinSetTitle($winarray1[$i][1],"",$winarray1[$i][0] & "-" & $j)
					$j = 100
				EndIf
				$j = $j + 1
			WEnd
		EndIf
	Next
	MsgBox(0,$VersionInfo,"All duplicate Diablo II windows have been renamed")
EndFunc


;=====================================================================
; by PortalDeamon000
Func _Update()
	FileDelete(@ScriptDir & "\version.dat")
	InetGet("http://www.portaldeamon.com/VersionKCH.txt", @ScriptDir & "\version.dat", 1, 0)
	$version = FileRead(@ScriptDir & "\version.dat")
	Local $size = FileGetSize(@ScriptDir & "\version.dat")
	if ($size < 3) Or ($size > 30) Then
		FileDelete(@ScriptDir & "\version.dat")
		MsgBox(48, "Updater", "ERROR!" & @CRLF & "Update Site Not Found")
		Return
	EndIf
	if $version = $VersionInfo Then
		FileDelete(@ScriptDir & "\version.dat")
		MsgBox(0, "Updater", "No New Updates")
		Return
	Else
		FileDelete(@ScriptDir & "\version.dat")
		$return = MsgBox(49, $VersionInfo, $version & " is avaiable for download." & @CRLF & "Click OK to download." )
		if $return = 1 Then ShellExecute("http://www.portaldeamon.com/kch_latest_release.zip")
		Return
	EndIf
EndFunc

#EndRegion

#Region advancedKCH

;=====================================================================
;=====================================================================
;=====================================================================
;----------Advanced KCH Version Main and Functions -------------------
;=====================================================================
;=====================================================================
;=====================================================================
Func _advanced()
	
	if Not FileExists($AdvClientFile) Then ;;make sure Client File Exists
		MsgBox(0,$VersionInfo,"Error, " & $AdvClientFile & " is not detected. Exiting")
		_exitadv()
	EndIf
	
	;; intro sound for cool (?) factor
	SoundPlay($HuntSoundFile)

	AutoItSetOption("TrayIconHide",1)
	AutoItSetOption("GUICoordMode",1)
	AutoItSetOption("GUIOnEventMode", 1)
	AutoItSetOption("WinDetectHiddenText", 1)
	AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
	$winarray1 = WinList("classname=Diablo II")
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

	Global $windowtitlearray[100][15]
#cs ;;Array Info
0 = Diablo Title
1 = Diablo Handle
2 = Client PID
3 = ControlID
4 = Tab

5 = Status
6 = Current Game
7 = Current IP
8 = Success Rate

9 = Hunted IP(s)
10 = Delay
11 = Prefix
12 = Pass
13 = Difficulty
14 = Sandbox
#ce

	$windowtitlearray[0][0] = $winarray1[0][0] ;;total number of windows

	$advGUI = GUICreate($VersionInfo & " Advanced",650, 400, 250, 200, $WS_THICKFRAME + $WS_MINIMIZEBOX + $WS_SYSMENU + $WS_CAPTION)
	GUISetOnEvent($GUI_EVENT_CLOSE, "_exitadv")
	GUICtrlCreateButton("Open Log",385,3)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent(-1, "_openlog")
	GUICtrlCreateButton("Check For Updates", 445, 3)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent(-1, "_Update")
	GUICtrlCreateButton("Open Readme",550,3)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent(-1, "_openreadme")
	$tab = GUICtrlCreateTab(10,10,630,380)
	GUICtrlSetResizing(-1,$GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)
	
	;;Tab 1 Controls
	$tab1 = GUICtrlCreateTabItem("Startup - Settings")
	$totallabel = GUICtrlCreateLabel("Detected Windows: " & $windowtitlearray[0][0] & @crlf & "Not Hunting: " & $windowtitlearray[0][0],50,50)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE)
	GUICtrlCreateButton("Refresh",170,50,60,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_liststartwindows")
	$winlist1 = GUICtrlCreateListView("Window         |Handle     ",40,80,195,300,$LVS_SHOWSELALWAYS,BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKBOTTOM + $GUI_DOCKLEFT + $GUI_DOCKRIGHT)
	
	GUICtrlCreateLabel("Select Saved Profile:", 270, 50, 120,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$profilecombo = GUICtrlCreateCombo("Default",395,50,165,20)
	Local $profilearray = IniReadSectionNames("KCHadv.ini")
	if not @error Then
		Local $string
		for $i = 1 to $profilearray[0]
			if Not (($profilearray[$i] == "Default")  OR ($profilearray[$i] == "Reserved")) Then $string = $string & $profilearray[$i] & "|"
		Next
		GUICtrlSetData(-1,StringTrimRight($string,1))
	EndIf
	$profile = "Default"
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Difficulty:",270,80,60,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$diffn = GUICtrlCreateRadio("Normal",330,80,60,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	$diffh = GUICtrlCreateRadio("Hell",395,80,50,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	if IniRead("KCHadv.ini","Default","Difficulty","Hell") = "Normal" Then
		GUICtrlSetState($diffn,$GUI_CHECKED)
	Else
		GUICtrlSetState($diffh,$GUI_CHECKED)
	EndIf
	GUICtrlCreateLabel("IP List:",270,102,50,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$ipinput = GUICtrlCreateInput(IniRead("KCHadv.ini","Default","Hunted Ip","66, 141"),330,105,230,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Game Duration:",270,130,95,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$durationinput = GUICtrlCreateInput(IniRead("KCHadv.ini","Default","Duration",180),375,130,185,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Game Name Prefix:",270,155,115,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$prefixinput = GUICtrlCreateInput(IniRead("KCHadv.ini","Default","Prefix","(random)"),395,155,165,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateLabel("Optional Game Password:",270,180,155,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetFont(-1,10)
	$passinput = GUICtrlCreateInput(IniRead("KCHadv.ini","Default","Password","(default)"),435,180,125,20)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlCreateButton("Hunt with Selected Windows and Settings -->",330,340,235,40)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_starthunt")
	GUICtrlCreateButton("Select All",250,210,75,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_select1")
	GUICtrlCreateButton("Unselect All",250,250,75,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_unselect1")
	GUICtrlCreateButton("Close D2",350,210,75,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKRIGHT)
	GUICtrlSetOnEvent( -1, "_close1")

	;;Tab 2 Controls
	$tab2 = GUICtrlCreateTabItem("Hunting Windows")
	$winlist2 = GUICtrlCreateListView("Window         |Status                    |Current Game   |Current IP     |Success Rate|Hunted Ip",25,80,590,300,$LVS_SHOWSELALWAYS,BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKBOTTOM + $GUI_DOCKLEFT + $GUI_DOCKRIGHT)
	GUICtrlCreateButton("Select All",25,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_select2")
	GUICtrlCreateButton("Unselect All",100,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_unselect2")
	GUICtrlCreateButton("Pause/Unpause",200,40,90,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_pauseadv")
	GUICtrlCreateButton("Change Ip",295,40,65,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_chgipadv")
	GUICtrlCreateButton("Change Delay",365,40,80,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_chgdelayadv")
	GUICtrlCreateButton("Join Game",450,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_joingameadv")
	GUICtrlCreateButton("Unload",565,40,50,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_close2")
	
	;;Tab 3 Controls
	$tab3 = GUICtrlCreateTabItem("Successful Windows")
	$winlist3 = GUICtrlCreateListView("Window         |Status                    |Current Game   |Current IP     |Success Rate|Hunted Ip",25,80,590,300,$LVS_SHOWSELALWAYS,BitOR($LVS_EX_GRIDLINES,$LVS_EX_CHECKBOXES))
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKBOTTOM + $GUI_DOCKLEFT + $GUI_DOCKRIGHT)
	GUICtrlCreateButton("Select All",25,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_select3")
	GUICtrlCreateButton("Unselect All",100,40,70,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_unselect3")
	GUICtrlCreateButton("Leave Game",300,40,90,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_leavegame")
	GUICtrlCreateButton("Copy Game/Pass",395,40,100,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_copygame")
	GUICtrlCreateButton("Unload",565,40,50,30)
	GUICtrlSetResizing(-1,$GUI_DOCKTOP + $GUI_DOCKSIZE + $GUI_DOCKLEFT)
	GUICtrlSetOnEvent( -1, "_close3")
	
	_liststartwindows()

	GUISetState(@SW_SHOW,$advGUI) ;Display GUI

	AdlibEnable("_getwinoutput",500)

	While 1
		if Not ($profile == GUICtrlRead($profilecombo)) Then
			_loadprofile()
			$profile = GUICtrlRead($profilecombo)
		EndIf
		Sleep(500)
	WEnd
EndFunc

Func _close1()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				WinClose($windowtitlearray[$i][1])
				_wipeentry($windowtitlearray[$i][1])
				Sleep(50)
			EndIf
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _close2()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_exitclient($windowtitlearray[$i][2])
				_MoveListItem($windowtitlearray[$i][1],1)
			EndIf
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _close3()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_exitclient($windowtitlearray[$i][2])
				_MoveListItem($windowtitlearray[$i][1],1)
			EndIf
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _select1()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_CHECKED)
		EndIf
	Next
EndFunc

Func _unselect1()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_UNCHECKED)
		EndIf
	Next
EndFunc

Func _select2()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_CHECKED)
		EndIf
	Next
EndFunc

Func _unselect2()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_UNCHECKED)
		EndIf
	Next
EndFunc

Func _select3()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_CHECKED)
		EndIf
	Next
EndFunc

Func _unselect3()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			GUICtrlSetState($windowtitlearray[$i][3],$GUI_UNCHECKED)
		EndIf
	Next
EndFunc

Func _pauseadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_output($windowtitlearray[$i][2],"pause")
			EndIf
		EndIf
	Next
EndFunc

Func _chgipadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	Local $val = 1
	$IPList_old = $IPList
	While $val = 1
		$val = 0
		Do
			$InputIPList = InputBox($VersionInfo & ": IP List", "Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address." & @CRLF & "Example: 66, 141" , "", " M",Default,Default,Default,Default,30)
        
			If @error <> 0 Then
				$InputIPList = StringStripWS($IPList_old, 8)  ;; strip all spaces
				$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
				
				ReDim $HuntedIPs [$SplitIPs[0]]
				$IPList = ""
    
				For $r = 1 To UBound($SplitIPs) - 1
					$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
					If $IPList = "" Then
						$IPList = $SplitIPs[$r]  ;; init to first split IP
					Else
						$IPList = $IPList & ", " & $SplitIPs[$r]
					EndIf
        
				Next
				Return
			EndIf
        
			$InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
			$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		Until $SplitIPs[0] >= 1
    
		;; first element of array after Split is number of returned elements
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""
    
		For $r = 1 To UBound($SplitIPs) - 1
			if Not StringIsInt($SplitIPs[$r]) Then
				MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
				$val = 1
			EndIf
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf
        
		Next
	WEnd
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$windowtitlearray[$i][9] = $IPList
				_output($windowtitlearray[$i][2],"chgip:" & $windowtitlearray[$i][9])
			EndIf
		EndIf
	Next
EndFunc

Func _chgdelayadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	Local $value
	Do
        $value = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", "", " M",Default,Default,Default,Default,30)
		if @error = 1 Then
			Return
		EndIf
    Until (($value >= 10) AND (StringIsInt($value)))
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$windowtitlearray[$i][10] = $value
				_output($windowtitlearray[$i][2],"delay:" & $windowtitlearray[$i][10])
			EndIf
		EndIf
	Next
EndFunc

Func _joingameadv()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	Local $value
	Do
        $value = InputBox($VersionInfo & ": Join Manual Game", "Enter a Game//Password to have the bot hold", "", " M",Default,Default,Default,Default,30)
		if @error = 1 Then
			Return
		EndIf
    Until StringLen($value) >= 1
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 2 Then ;Check if in second tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_output($windowtitlearray[$i][2],"join:" & $value)
				ExitLoop ;;make sure we only tell 1 window to join
			EndIf
		EndIf
	Next
EndFunc

Func _leavegame()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				_output($windowtitlearray[$i][2],"leave")
			EndIf
		EndIf
	Next
EndFunc

Func _copygame()
	local $totalval = 0
	Local $clip = ""
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = $totalval + 1
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 3 Then ;Check if in third tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				if Not (($windowtitlearray[$i][6] == "") Or ($windowtitlearray[$i][6] == " ")) then
					if $totalval > 1 Then
						$clip = $clip & $windowtitlearray[$i][6] & @CRLF
					ElseIf $totalval = 1 Then
						$clip = $windowtitlearray[$i][6]
					EndIf
				EndIf
			EndIf
		EndIf
	Next
	if StringLen($clip) > 0 Then ClipPut($clip)
EndFunc

Func _loadprofile()
	Local $newprofile = GUICtrlRead($profilecombo)
	if IniRead("KCHadv.ini",$newprofile,"Difficulty","Hell") = "Normal" Then
		GUICtrlSetState($diffn,$GUI_CHECKED)
	Else
		GUICtrlSetState($diffh,$GUI_CHECKED)
	EndIf
	GUICtrlSetData($ipinput,IniRead("KCHadv.ini",$newprofile,"Hunted Ip","66, 141"))
	GUICtrlSetData($durationinput,IniRead("KCHadv.ini",$newprofile,"Duration",180))
	GUICtrlSetData($prefixinput,IniRead("KCHadv.ini",$newprofile,"Prefix","(random)"))
	GUICtrlSetData($passinput,IniRead("KCHadv.ini",$newprofile,"Password","(default)"))
EndFunc

Func _starthunt()
	local $totalval = 0
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
			if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
				$totalval = 1
				ExitLoop
			EndIf
		EndIf
	Next
	if $totalval = 0 Then
		MsgBox(0,$VersionInfo, "No Windows Selected!",5)
		Return
	EndIf
	$checkval = _verifysettings()
	if $checkval = 0 Then
		IniWrite("KCHadv.ini",$profile,"Hunted IP",GUICtrlRead($ipinput))
		IniWrite("KCHadv.ini",$profile,"Duration",GUICtrlRead($durationinput))
		IniWrite("KCHadv.ini",$profile,"Prefix",GUICtrlRead($prefixinput))
		IniWrite("KCHadv.ini",$profile,"Password",GUICtrlRead($passinput))
		if GUICtrlRead($diffh) = $GUI_CHECKED Then
			IniWrite("KCHadv.ini",$profile,"Difficulty","Hell")
		Elseif GUICtrlRead($diffn) = $GUI_CHECKED Then
			IniWrite("KCHadv.ini",$profile,"Difficulty","Normal")
		EndIf
		Local $startnum1 = 0
		Local $startnum2 = 0
		;; Loop through first to get the total number of windows to launch
		for $i = 1 to (UBound($windowtitlearray) -1)
			if Not ($windowtitlearray[$i][0] == "") Then ;Make sure window exists
				if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
					if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
						if Not (GUICtrlRead($prefixinput) == "(random)") Then
							for $j = 1 to (UBound($windowtitlearray) -1)
								if $windowtitlearray[$j][11] = GUICtrlRead($prefixinput) Then
									ContinueLoop ;go to next loop
								EndIf
							Next
						EndIf
						$startnum1 = $startnum1 + 1
					EndIf
				EndIf
			EndIf
		Next
		
		for $i = 1 to (UBound($windowtitlearray) -1)
			if Not ($windowtitlearray[$i][0] == "") Then ;Make sure window exists
				if $windowtitlearray[$i][4] = 1 Then ;Check if in first tab
					if BitAND(GUICtrlRead($windowtitlearray[$i][3] ,1),$GUI_CHECKED) Then ;Check if selected
						if Not (GUICtrlRead($prefixinput) == "(random)") Then
							for $j = 1 to (UBound($windowtitlearray) -1)
								if $windowtitlearray[$j][11] = GUICtrlRead($prefixinput) Then
									MsgBox(0,$VersionInfo, "Error: Game Prefix must be unique!")
									ContinueLoop 2 ;go to next loop
								ElseIf $j = (UBound($windowtitlearray) -1) Then
									$windowtitlearray[$i][11] = GUICtrlRead($prefixinput)
								EndIf
							Next
						Else
							$windowtitlearray[$i][11] = Chr(96 + Random(1, 26, 1)) & Random(100, 999, 1) & "-"
						EndIf
						$windowtitlearray[$i][9] = GUICtrlRead($ipinput)
						$windowtitlearray[$i][10] = GUICtrlRead($durationinput)
						$windowtitlearray[$i][12] = GUICtrlRead($passinput)
						if GUICtrlRead($diffh) = $GUI_CHECKED Then
							$windowtitlearray[$i][13] = "h"
						Elseif GUICtrlRead($diffn) = $GUI_CHECKED Then
							$windowtitlearray[$i][13] = "n"
						EndIf
						Local $classname = _WinAPI_GetClassName($windowtitlearray[$i][1])
						if StringRegExp($classname,'\ASandbox:([A-Za-z0-9]+):Diablo II\Z',0) Then ;;check if it is inside a sandbox so we can launch KCHClient properly
							$windowtitlearray[$i][14] = StringTrimRight(StringTrimLeft($classname,8),10)
						EndIf
						_launchclient($windowtitlearray[$i][1],$startnum2*$windowtitlearray[$i][10]/$startnum1)
						if Not ($windowtitlearray[$i][2] == -1) Then _MoveListItem($windowtitlearray[$i][1], 2) ;;check if launched correctly
						$startnum2 = $startnum2 + 1
					EndIf
				EndIf
			EndIf
		Next
		
	ElseIf $checkval = 2 Then
		GUICtrlSetState($ipinput,$GUI_FOCUS)
	ElseIf $checkval = 3 Then
		GUICtrlSetState($durationinput,$GUI_FOCUS)
	ElseIf $checkval = 4 Then
		GUICtrlSetState($prefixinput,$GUI_FOCUS)
	ElseIf $checkval = 5 Then
		GUICtrlSetState($passinput,$GUI_FOCUS)
	EndIf
EndFunc

Func _verifysettings()
	$InputIPList = StringStripWS(GUICtrlRead($ipinput), 8)  ;; strip all spaces
	$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
	if Not ($SplitIPs[0] >= 1) Then
		MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
		Return 2
	EndIf
	if Not (GUICtrlRead($durationinput) >= 10 And StringIsInt(GUICtrlRead($durationinput))) Then
		MsgBox(48,$VersionInfo,"Game Duration must be an integer and greater than 10 seconds!")
		Return 3
	EndIf

	if GUICtrlRead($prefixinput) = "" Or StringLen(GUICtrlRead($prefixinput)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Prefix must exist and cannot exceed 10 characters!")
		Return 4
	EndIf

	Local $val = GUICtrlRead($prefixinput)
	if Not ($val == "(random)") Then
		for $i=1 to StringLen($val)
			Local $val2 = StringMid($val,$i,1)
			if Not (StringIsAlNum($val2) or ($val2 == "-") or ($val2 == "_") or ($val2 == "'") or (($val2 == " ") And ($i > 1))) Then
				MsgBox(48,$VersionInfo,"Game Prefix cannot contain those invalid characters")
				Return 4
			EndIf
		Next
	EndIf
	
	if StringLen(GUICtrlRead($passinput)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Password cannot exceed 10 characters!")
		Return 5
	EndIf
	
	Local $val = GUICtrlRead($passinput)
	if Not ($val == "(default)") Then
		for $i=1 to StringLen($val)
			Local $val2 = StringMid($val,$i,1)
			if Not (StringIsAlNum($val2) or ($val2 == "-") or ($val2 == "_") or ($val2 == "'") or (($val2 == " ") And ($i > 1))) Then
				MsgBox(48,$VersionInfo,"Game Password cannot contain those invalid characters")
				Return 5
			EndIf
		Next
	EndIf
	
	;; first element of array after Split is number of returned elements
    ReDim $HuntedIPs [$SplitIPs[0]]
    $IPList = ""
	For $r = 1 To UBound($SplitIPs) - 1
		if Not StringIsInt($SplitIPs[$r]) Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		ElseIf StringLen($SplitIPs[$r]) > 3 Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		ElseIf StringLen($SplitIPs[$r]) < 2 Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		EndIf
    Next
	Return 0
EndFunc

Func _exitadv()
	_exitall()
	Exit
EndFunc

Func _openlog()
	ShellExecute("KCHlog.txt")
EndFunc

Func _openreadme()
	ShellExecute("readme.txt")
EndFunc

Func _MoveListItem($handle, $tabnum)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][1] = $handle Then
			if Not ($tabnum == $windowtitlearray[$i][4]) Then ;;Make sure we dont try to move it to the same tab
				if $tabnum = 1 Then
					$windowtitlearray[$i][2] = -1
					GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI Control
					$windowtitlearray[$i][3] = GUICtrlCreateListViewItem($windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][1], $winlist1) ;;Create GUI Control in Tab1
					$windowtitlearray[$i][4] = 1
					$windowtitlearray[$i][5] = ""
					$windowtitlearray[$i][6] = ""
					$windowtitlearray[$i][7] = ""
					$windowtitlearray[$i][8] = ""
					$windowtitlearray[$i][9] = ""
					$windowtitlearray[$i][10] = ""
					$windowtitlearray[$i][11] = ""
					$windowtitlearray[$i][12] = ""
					$windowtitlearray[$i][13] = ""
					$windowtitlearray[$i][14] = ""
				ElseIf $tabnum = 2 Then
					GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI Control
					$windowtitlearray[$i][3] = GUICtrlCreateListViewItem($windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9], $winlist2) ;;Create GUI Control in Tab2
					$windowtitlearray[$i][4] = 2
				ElseIf $tabnum = 3 Then
					GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI Control
					$windowtitlearray[$i][3] = GUICtrlCreateListViewItem($windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9], $winlist3) ;;Create GUI Control in Tab3
					$windowtitlearray[$i][4] = 3
				EndIf
			EndIf
			ExitLoop
		EndIf
	Next
	_liststartwindows()
EndFunc

Func _liststartwindows()
	AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
	$winarray1 = WinList("classname=Diablo II")
	$winarray2 = WinList("[REGEXPCLASS:\ASandbox:([A-Za-z0-9]+):Diablo II\Z]") ;scan for sandboxie D2 windows
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

	$windowtitlearray[0][0] = $winarray1[0][0] + $winarray2[0][0] ;;total number of windows

	for $i = 1 to (UBound($windowtitlearray) -1) ;Make sure all windows still exist
		if Not ($windowtitlearray[$i][0] == "") Then ;Make sure data entry exists
			Local $winval = 0
			;loop through regular windows
			for $j = 1 to $winarray1[0][0]
				if $windowtitlearray[$i][1] == $winarray1[$j][1] Then ;;matching winhandles
					ExitLoop
				ElseIf $j >= $winarray1[0][0] Then ;reached end of winlist and not present
					$winval = 1
				EndIf
			Next
			;loop through sandboxed windows
			for $j = 1 to $winarray2[0][0]
				if $windowtitlearray[$i][1] == $winarray2[$j][1] Then ;;matching winhandles
					ExitLoop
				ElseIf $j >= $winarray2[0][0] Then ;reached end of winlist and not present
					If $winval = 1 Then
						if Not ($windowtitlearray[$i][2] == -1) Then ;client exists
							_exitclient($windowtitlearray[$i][2])
							MsgBox(0,$VersionInfo,"Window: " & $windowtitlearray[$i][0] & " does not exist anymore. Stopping that instance")
						EndIf
						_wipeentry($windowtitlearray[$i][1]) ;clear data entry and remove from GUI
					EndIf
				EndIf
			Next
			if Not WinExists($windowtitlearray[$i][1]) Then _wipeentry($windowtitlearray[$i][1]) ;clear data entry and remove from GUI
		EndIf
	Next

	;loop through regular windows
	for $i = 1 to $winarray1[0][0]
		Local $exists = 0
		for $k = 1 to (UBound($windowtitlearray) -1) ;Make sure window entry doesn't already exist
			if $winarray1[$i][1] = $windowtitlearray[$k][1] Then
				$exists = 1
				ExitLoop
			EndIf
		Next
		if $exists = 0 Then
			for $j = 1 to (UBound($windowtitlearray) -1) ;Add new windows if not entered yet
				if $windowtitlearray[$j][0] = "" Then ;Make sure entry is blank
					$windowtitlearray[$j][0] = $winarray1[$i][0] ;;window title
					$windowtitlearray[$j][1] = $winarray1[$i][1] ;;window handle
					$windowtitlearray[$j][2] = -1 ;;null client pid
					$windowtitlearray[$j][3] = GUICtrlCreateListViewItem($windowtitlearray[$j][0] & "|" & $windowtitlearray[$j][1] ,$winlist1)
					$windowtitlearray[$j][4] = 1
					GUICtrlSetState($windowtitlearray[$j][3],$GUI_CHECKED)
					ExitLoop ;;added, onto next entry
				ElseIf $j >= 99 Then
					MsgBox(0,$VersionInfo,"Error, too many windows. Max of 99 reached. Please edit the code manually to allow more")
					ExitLoop 2 ;;Stop looping, error
				EndIf
			Next
		EndIf
	Next
	;loop through sandboxed windows
	for $i = 1 to $winarray2[0][0]
		Local $exists = 0
		for $k = 1 to (UBound($windowtitlearray) -1) ;Make sure window entry doesn't already exist
			if $winarray2[$i][1] = $windowtitlearray[$k][1] Then
				$exists = 1
				ExitLoop
			EndIf
		Next
		if $exists = 0 Then
			for $j = 1 to (UBound($windowtitlearray) -1) ;Add new windows if not entered yet
				if $windowtitlearray[$j][0] = "" Then ;Make sure entry is blank
					$windowtitlearray[$j][0] = $winarray2[$i][0] ;;window title
					$windowtitlearray[$j][1] = $winarray2[$i][1] ;;window handle
					$windowtitlearray[$j][2] = -1 ;;null client pid
					$windowtitlearray[$j][3] = GUICtrlCreateListViewItem($windowtitlearray[$j][0] & "|" & $windowtitlearray[$j][1] ,$winlist1)
					$windowtitlearray[$j][4] = 1
					GUICtrlSetState($windowtitlearray[$j][3],$GUI_CHECKED)
					ExitLoop ;;added, onto next entry
				ElseIf $j >= 99 Then
					MsgBox(0,$VersionInfo,"Error, too many windows. Max of 99 reached. Please edit the code manually to allow more")
					ExitLoop 2 ;;Stop looping, error
				EndIf
			Next
		EndIf
	Next
	
	Local $total = 0 ;total number of non-hunting windows
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][4] = 1 Then $total = $total + 1
	Next
	
	GUICtrlSetData($totallabel, "Detected Windows: " & $windowtitlearray[0][0] & @crlf & "Not Hunting: " & $total)
EndFunc

Func _wipeentry($handle)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][1] = $handle Then
			if Not ($windowtitlearray[$i][3] == "") Then GUICtrlDelete($windowtitlearray[$i][3]) ;;Delete GUI entry if it exists
			;;Remove all data on entry
			$windowtitlearray[$i][0] = ""
			$windowtitlearray[$i][1] = ""
			$windowtitlearray[$i][2] = ""
			$windowtitlearray[$i][3] = ""
			$windowtitlearray[$i][4] = ""
			$windowtitlearray[$i][5] = ""
			$windowtitlearray[$i][6] = ""
			$windowtitlearray[$i][7] = ""
			$windowtitlearray[$i][8] = ""
			$windowtitlearray[$i][9] = ""
			$windowtitlearray[$i][10] = ""
			$windowtitlearray[$i][11] = ""
			$windowtitlearray[$i][12] = ""
			$windowtitlearray[$i][13] = ""
			$windowtitlearray[$i][14] = ""
			ExitLoop
		EndIf
	Next
EndFunc

Func _launchclient($handle, $startdelay = 0)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][0] == "") Then ;;has a valid window
			if $windowtitlearray[$i][1] = $handle Then
				$pidreturn = _RunClient($windowtitlearray[$i][1],$windowtitlearray[$i][13],$windowtitlearray[$i][9],$windowtitlearray[$i][10],$windowtitlearray[$i][11],$windowtitlearray[$i][12],$windowtitlearray[$i][14],$startdelay)
				if Not ($pidreturn == -1) Then $windowtitlearray[$i][2] = $pidreturn
			EndIf
		EndIf
	Next
EndFunc

Func _exitclient($pid)
	for $i = 1 to (UBound($windowtitlearray) -1)
		if $windowtitlearray[$i][2] = $pid Then
			_output($windowtitlearray[$i][2], "exit")
			ExitLoop
		EndIf
	Next
EndFunc

Func _exitall()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][2] == "") Then
			_output($windowtitlearray[$i][2], "exit")
			_wipeentry($windowtitlearray[$i][1])
		EndIf
	Next
EndFunc

Func _RunClient($handle, $difficulty, $ips, $delay, $prefix, $pass, $sandbox, $startdelay)
	if Not FileExists($AdvClientFile) Then
		MsgBox(0,$VersionInfo,"Error, " & $AdvClientFile & " is not detected. Exiting")
		_exitadv()
	EndIf
	Local $pid
	if $sandbox == "" Then ;;regular d2 window
		$pid = Run($AdvClientFile & " launch")
		if @error Then Return -1
		Local $i = 1
		while $i < 20 ;;Give the program time to load
			if WinExists("KCHClient-" & $pid) then ExitLoop
			$i = $i + 1
			Sleep(250)
		WEnd
		if $i >= 20 Then
			MsgBox(0,$VersionInfo,"Failed to launch KCH's client process correctly",3)
			Return -1
		EndIf
	Else ;;sandboxed d2 window
		Run(IniRead("KCHadv.ini","Reserved","Sandboxie","C:\Program Files\Sandboxie\") & "Start.exe /silent /box:" & $sandbox & " " & @ScriptDir & "\" & $AdvClientFile & " launch")
		if @error Then Return -1
		Local $i = 1
		while $i < 30 ;;Give the program time to load
			AutoItSetOption("WinTitleMatchMode", 4)  ;; classname
			$sandarray = WinList("classname=Sandbox:" & $sandbox & ":AutoIt v3 GUI")
			AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match
			for $i = 1 to $sandarray[0][0]
				Local $regexp = StringRegExp($sandarray[$i][0], "KCHClient-[\d]*", 1)
				for $j = 0 to UBound($regexp) - 1
					$pid = StringTrimLeft($regexp[$j],10)
					ExitLoop 3
				Next
			Next
			Sleep(250)
		WEnd
		if $i >= 30 Then
			MsgBox(0,$VersionInfo,"Failed to launch KCH's client process in the sandbox: " & $sandbox & " correctly",3)
			Return -1
		EndIf
		
	EndIf
		

	_output($pid, "start|" & $handle &"|"& $difficulty & "|" & $ips &"|"& Int($delay) &"|"& $prefix &"|"& $pass & "|" & WinGetProcess($handle) & "|" & Int($startdelay))
	Return $pid
EndFunc

Func _output($pid, $message)
	AutoItSetOption("WinTitleMatchMode", 2)  ;; any
	Local $list = WinList("KCHClient-" & $pid)
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact
	for $i = 1 to $list[0][0]
		if StringRegExp($list[$i][0],"KCHClient-" & $pid & "[\D]?") Then ;;make sure the string ends where specified
			ControlSetText($list[$i][1],"",3,$message) ;;output
			ExitLoop
		EndIf
	Next
EndFunc

Func _getwinoutput()
	for $i = 1 to (UBound($windowtitlearray) -1)
		if Not ($windowtitlearray[$i][0] == "") Then ;Make sure data entry exists
			if Not ($windowtitlearray[$i][2] == -1) Then ;Make sure client pid exists
				AutoItSetOption("WinTitleMatchMode", 2)  ;; any
				Local $list = WinList("KCHClient-" & $windowtitlearray[$i][2])
				AutoItSetOption("WinTitleMatchMode", 3)  ;; exact
				for $j = 1 to $list[0][0]
					if StringRegExp($list[$j][0],"KCHClient-" & $windowtitlearray[$i][2] & "[\D]?") Then ;;make sure the string ends where specified
						Local $winoutput = ControlGetText($list[$j][1],"",4)
						if @error Then
							_wipeentry($windowtitlearray[$i][1])
						Else
							if StringLen($winoutput) >= 3 Then ;Make sure string is really there
								Local $winoutput2 = StringSplit($winoutput,'|')
								if $winoutput2[0] == 4 Then ;;make sure we don't get an autoit error
									$windowtitlearray[$i][5] = $winoutput2[1]
									$windowtitlearray[$i][6] = $winoutput2[2]
									$windowtitlearray[$i][7] = $winoutput2[3]
									$windowtitlearray[$i][8] = $winoutput2[4]
									if $windowtitlearray[$i][4] = 2 Then
										GUICtrlSetData($windowtitlearray[$i][3],$windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9])
										if StringLeft($winoutput,5) == "Found" Then _MoveListItem($windowtitlearray[$i][1],3)
										if StringLeft($winoutput,8) == "Detected" Then _MoveListItem($windowtitlearray[$i][1],3)
										if StringLeft($winoutput,4) == "Held" Then _MoveListItem($windowtitlearray[$i][1],3)
										if StringLeft($winoutput,9) == "Rejoining" Then _MoveListItem($windowtitlearray[$i][1],3)
									elseif $windowtitlearray[$i][4] = 3 Then
										GUICtrlSetData($windowtitlearray[$i][3],$windowtitlearray[$i][0] & "|" & $windowtitlearray[$i][5] & "|" & $windowtitlearray[$i][6] & "|" & $windowtitlearray[$i][7] & "|" & $windowtitlearray[$i][8] & "|" & $windowtitlearray[$i][9])
										if StringLeft($winoutput,7) == "Hunting" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,5) == "lobby" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,6) == "ingame" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,3) == "FTJ" Then _MoveListItem($windowtitlearray[$i][1],2)
										if StringLeft($winoutput,8) == "Creating" Then _MoveListItem($windowtitlearray[$i][1],2)
									EndIf
								EndIf
							EndIf
						EndIf
						
						ExitLoop
					EndIf
				Next
			EndIf
		EndIf
	Next
		
	Sleep(50)	
EndFunc
;~ ControlGetText("KCHClient-" & $pid,"",4) ;;input
;~ ControlSetText("KCHClient-" & $pid,"",3,"exit") ;;output
#EndRegion